<!DOCTYPE html>
<?php if(session()->get('text_direction') == 'rtl'): ?>
    <html class="no-js" lang="en" dir="rtl">
<?php else: ?>
    <html class="no-js" lang="en">
<?php endif; ?>

<head>
    <!-- Meta Tags -->
    <meta name="viewport" content="width=device-width,initial-scale=1.0" />
    <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <?php
        $appName = $setting->app_name;
        try {
            $routeName = str(Route::currentRouteName())
                ->replace('_', ' - ')
                ->replace('-', ' - ')
                ->replace('.', ' - ')
                ->title();
        } catch (\Exception $e) {
            info($e);
            $routeName = '';
        }
        $SeoTitle = $routeName . ' || ' . $appName;
    ?>

    <!-- Title -->
    <?php echo $__env->yieldContent('title'); ?>
    <?php echo $__env->yieldContent('meta'); ?>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?php echo e(asset($setting->favicon) ?? ''); ?>">

    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php echo $__env->make('layouts.client.style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('css'); ?>
    <?php if(customCode()?->css): ?>
        <style>
            <?php echo customCode()->css; ?>

        </style>
    <?php endif; ?>

    <?php if($setting->googel_tag_status == 'active'): ?>
        <!-- Google Tag Manager -->
        <script>
            (function(w, d, s, l, i) {
                w[l] = w[l] || [];
                w[l].push({
                    'gtm.start': new Date().getTime(),
                    event: 'gtm.js'
                });
                var f = d.getElementsByTagName(s)[0],
                    j = d.createElement(s),
                    dl = l != 'dataLayer' ? '&l=' + l : '';
                j.async = true;
                j.src =
                    'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
                f.parentNode.insertBefore(j, f);
            })(window, document, 'script', 'dataLayer', '<?php echo e($setting->googel_tag_id); ?>');
            // Initialize Data Layer
            window.dataLayer = window.dataLayer || [];
        </script>
        <!-- End Google Tag Manager -->
    <?php endif; ?>

    <?php if($setting->google_analytic_status == 'active'): ?>
        <!-- Global site tag (gtag.js) - Google Analytics -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e($setting->google_analytic_id); ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());
            gtag('config', '<?php echo e($setting->google_analytic_id); ?>');
        </script>
    <?php endif; ?>

    <?php if($setting->pixel_status == 'active'): ?>
        <!-- Meta Pixel Code -->
        <script>
            ! function(f, b, e, v, n, t, s) {
                if (f.fbq) return;
                n = f.fbq = function() {
                    n.callMethod ?
                        n.callMethod.apply(n, arguments) : n.queue.push(arguments)
                };
                if (!f._fbq) f._fbq = n;
                n.push = n;
                n.loaded = !0;
                n.version = '2.0';
                n.queue = [];
                t = b.createElement(e);
                t.async = !0;
                t.src = v;
                s = b.getElementsByTagName(e)[0];
                s.parentNode.insertBefore(t, s)
            }(window, document, 'script',
                'https://connect.facebook.net/en_US/fbevents.js');
            fbq('init', '<?php echo e($setting->pixel_app_id); ?>');
            fbq('track', 'PageView');
        </script>

        <noscript><img height="1" width="1" style="display:none"
                src="https://www.facebook.com/tr?id=<?php echo e($setting->pixel_app_id); ?>&ev=PageView&noscript=1" /></noscript>
        <!-- End Meta Pixel Code -->
    <?php endif; ?>
    <?php if(customCode()?->header_javascript): ?>
        <script>
            "use strict";
            <?php echo customCode()->header_javascript; ?>

        </script>
    <?php endif; ?>

</head>

<body>
    <!--============================
    Google Tag Manager
    ==============================-->
    <?php if($setting->googel_tag_status == 'active'): ?>
        <!-- Google Tag Manager (noscript) -->
        <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=<?php echo e($setting->googel_tag_id); ?>" height="0"
                width="0" style="display:none;visibility:hidden"></iframe></noscript>
        <!-- End Google Tag Manager (noscript) -->
    <?php endif; ?>

    <!--Preloader Start-->
    <?php if($setting->preloader == 1): ?>
        <div id="preloader" class="preloader">
            <div class="status" style="background-image: url(<?php echo e(url($setting->preloader_image)); ?>)"></div>
        </div>
    <?php endif; ?>
    <!--Preloader End-->
    <?php if(customCode()?->body_javascript): ?>
        <script>
            "use strict";
            <?php echo customCode()->body_javascript; ?>

        </script>
    <?php endif; ?>

    <!--Header-Area Start-->
    <div class="header-area">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-xxl-2 col-lg-3 col-12">
                    <div class="header-social">
                        <ul>
                            <li>
                                <div class="social-bar">
                                    <ul>
                                        <?php $__currentLoopData = getSocialLinks(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><a target="_blank" aria-label="<?php echo e($social?->link); ?>"
                                                    href="<?php echo e($social?->link); ?>">
                                                    <i class="<?php echo e($social?->icon); ?>"></i>
                                                </a>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-xxl-10 col-lg-9 col-12">
                    <div class="header-info">
                        <ul>
                            <?php if($contactInfo?->top_bar_email): ?>
                                <li>
                                    <i class="far fa-envelope"></i>
                                    <span><?php echo e($contactInfo?->top_bar_email); ?></span>
                                </li>
                            <?php endif; ?>
                            <?php if($contactInfo?->top_bar_phone): ?>
                                <li>
                                    <i class="fas fa-phone"></i>
                                    <span>+<?php echo e($contactInfo?->top_bar_phone); ?></span>
                                </li>
                            <?php endif; ?>
                            <?php if(allLanguages()?->where('status', 1)->count() > 1): ?>
                                <li>
                                    <form id="setLanguageHeader" action="<?php echo e(route('set-language')); ?>" method="get">
                                        <select class="select_js" name="code">
                                            <?php $__empty_1 = true; $__currentLoopData = allLanguages()?->where('status', 1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <option value="<?php echo e($language->code); ?>"
                                                    <?php echo e(getSessionLanguage() == $language->code ? 'selected' : ''); ?>>
                                                    <?php echo e($language->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <option value="en"
                                                    <?php echo e(getSessionLanguage() == 'en' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('English')); ?>

                                                </option>
                                            <?php endif; ?>
                                        </select>
                                    </form>
                                </li>
                            <?php endif; ?>
                            <?php if(allCurrencies()?->where('status', 'active')->count() > 1): ?>
                                <li>
                                    <form id="setCurrencyHeader" action="<?php echo e(route('set-currency')); ?>" method="get">
                                        <select class="select_js" name="currency">
                                            <?php $__empty_1 = true; $__currentLoopData = allCurrencies()?->where('status', 'active'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <option value="<?php echo e($currency->currency_code); ?>"
                                                    <?php echo e(getSessionCurrency() == $currency->currency_code ? 'selected' : ''); ?>>
                                                    <?php echo e($currency->currency_name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <option value="USD"
                                                    <?php echo e(getSessionCurrency() == 'USD' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('USD')); ?>

                                                </option>
                                            <?php endif; ?>
                                        </select>
                                    </form>
                                </li>
                            <?php endif; ?>

                            <?php if(auth()->guard()->guest()): ?>
                                <li>
                                    <a aria-label="<?php echo e(__('Login')); ?>" href="<?php echo e(url('login')); ?>"><i
                                            class="fas fa-user"></i></a>
                                </li>
                            <?php else: ?>
                                <li>
                                    <a aria-label="<?php echo e(__('Dashboard')); ?>" href="<?php echo e(route('dashboard')); ?>"><i
                                            class="fas fa-user"></i></a>
                                </li>
                            <?php endif; ?>
                            <li>
                                <a aria-label="<?php echo e(__('Appointment List')); ?>" href="<?php echo e(route('client.payment')); ?>"><i
                                        class="fas fa-shopping-cart position-relative"></i><span
                                        class="badge bg-danger position-absolute shopping-cart"><?php echo e(Cart::count() > 0 ? Cart::count() : ''); ?></span></a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--Header-Area End-->


    <!--Menu Start-->
    <div id="strickymenu" class="menu-area">
        <div class="container">
            <div class="row">
                <div class="col-md-3 col-6">
                    <div class="logo flex">
                        <a aria-label="<?php echo e($setting?->app_name); ?>" href="<?php echo e(url('/')); ?>"><img
                                src="<?php echo e(asset($setting->logo)); ?>" alt="<?php echo e($setting?->app_name); ?>" loading="lazy"></a>
                    </div>
                </div>
                <div class="col-md-9 col-6">
                    <div class="main-menu">
                        <ul class="nav-menu">
                            <?php if($public_menu = mainMenu()): ?>
                                <?php $__currentLoopData = $public_menu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $is_child =
                                            isset($menu['child']) &&
                                            is_array($menu['child']) &&
                                            count($menu['child']) > 0;
                                    ?>
                                    <li class="<?php if($is_child): ?> menu-item-has-children <?php endif; ?>"><a
                                            <?php if($menu['open_new_tab']): ?> target="_blank" <?php endif; ?>
                                            href="<?php echo e($menu['link'] == '#' || empty($menu['link']) ? 'javascript:;' : url($menu['link'])); ?>"><?php echo e($menu['label']); ?></a>
                                        <?php if($is_child): ?>
                                            <ul class="sub-menu">
                                                <?php $__currentLoopData = $menu['child']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><a <?php if($child['open_new_tab']): ?> target="_blank" <?php endif; ?>
                                                            href="<?php echo e($child['link'] == '#' || empty($child['link']) ? 'javascript:;' : url($child['link'])); ?>"><?php echo e($child['label']); ?></a>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        <?php endif; ?>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <li class="special-button"><a href="javascript:;" aria-label="<?php echo e(__('Appointment')); ?>"
                                        data-bs-toggle="modal"
                                        data-bs-target="#appointment_modal"><?php echo e(__('Appointment')); ?></a></li>
                            <?php else: ?>
                                <li><a aria-label="<?php echo e(__('Home')); ?>"
                                        href="<?php echo e(route('home')); ?>"><?php echo e(__('Home')); ?></a></li>
                            <?php endif; ?>
                        </ul>
                    </div>

                    <!--Mobile Menu Icon Start-->
                    <div class="mobile-menuicon">
                        <span class="menu-bar" onclick="openNav()"><i class="fas fa-bars" aria-hidden="true"></i></span>
                    </div>
                    <!--Mobile Menu Icon End-->
                </div>
            </div>
        </div>
    </div>
    <!--Menu End-->
    <?php
        $getDepartments = getDepartments();
    ?>

    <!--Mobile Menu Start-->
    <div class="mobile-menu">
        <div id="mySidenav" class="sidenav">
            <a aria-label="<?php echo e($setting?->app_name); ?>" href="<?php echo e(url('/')); ?>"><img
                    src="<?php echo e(url($setting->logo)); ?>" alt="<?php echo e($setting?->app_name); ?>" loading="lazy"></a>
            <span class="closebtn" onclick="closeNav()">&times;</span>

            <?php if($public_menu = mainMenu()): ?>
                <ul>
                    <?php $__currentLoopData = $public_menu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $is_child = isset($menu['child']) && is_array($menu['child']) && count($menu['child']) > 0;
                        ?>
                        <li class="<?php if($is_child): ?> menu-child <?php endif; ?>">
                            <?php if($is_child): ?>
                                <span><?php echo e($menu['label']); ?></span>
                                <ul>
                                    <?php $__currentLoopData = $menu['child']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a
                                                href="<?php echo e($child['link'] == '#' || empty($child['link']) ? 'javascript:;' : url($child['link'])); ?>"><?php echo e($child['label']); ?></a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php else: ?>
                                <a
                                    href="<?php echo e($menu['link'] == '#' || empty($menu['link']) ? 'javascript:;' : url($menu['link'])); ?>"><?php echo e($menu['label']); ?></a>
                            <?php endif; ?>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <li class="special-button"><a aria-label="<?php echo e(__('Appointment')); ?>" href="javascript:;"
                            data-bs-toggle="modal" data-bs-target="#appointment_modal1"><?php echo e(__('Appointment')); ?></a>
                    </li>

                    <!-- Modal -->
                    <div class="modal fade" id="appointment_modal1" role="dialog"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Create Appointment')); ?>

                                    </h5>
                                    <button type="button" class="close" data-bs-dismiss="modal"
                                        aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body book-appointment">

                                    <form action="<?php echo e(url('create-appointment')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <div class="form-group">
                                            <label for=""><?php echo e(__('Select Department')); ?></label>
                                            <select name="department_id" onchange="loadMobileModallawyer()"
                                                class="modal-department-id select_js">
                                                <option value=""><?php echo e(__('Select Department')); ?></option>
                                                <?php $__currentLoopData = $getDepartments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </select>
                                        </div>

                                        <div class="form-group d-none" id="mobile-modal-lawyer-box">
                                            <label for=""><?php echo e(__('Select Lawyer')); ?></label>
                                            <select name="" class="form-select modal-lawyer-id mySelect2Item"
                                                onchange="loadModalDate()">
                                                <option value=""><?php echo e(__('Select Lawyer')); ?></option>
                                            </select>
                                        </div>
                                        <div class="form-group d-none" id="mobile-modal-date-box">
                                            <label for=""><?php echo e(__('Select Date')); ?></label>
                                            <input type="text" name="date" class="form-control datepicker"
                                                id="mobile-modal-datepicker-value">
                                            <input type="hidden" name="lawyer_id" value=""
                                                id="mobile_modal_lawyer_id">
                                        </div>

                                        <div class="form-group d-none" id="mobile-modal-schedule-box">
                                            <label for=""><?php echo e(__('Select Schedule')); ?></label>
                                            <select name="schedule_id" class="form-select mySelect2Item"
                                                id="available-mobile-modal-schedule">

                                            </select>
                                        </div>
                                        <div id="mobile-modal-schedule-error" class="d-none"></div>
                                        <div class="form-group">
                                            <button type="button" class="btn btn-danger"
                                                data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                                            <input type="submit" value="<?php echo e(__('Submit')); ?>"
                                                class="btn btn-primary" id="mobile-modal-sub" disabled>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
                </ul>
            <?php endif; ?>
        </div>
    </div>
    <!--Mobile Menu End-->

    <!-- Modal -->
    <div class="modal fade" id="appointment_modal" role="dialog" aria-labelledby="exampleModalLabelTwo"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabelTwo"><?php echo e(__('Create Appointment')); ?></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body book-appointment">
                    <form action="<?php echo e(url('create-appointment')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label for=""><?php echo e(__('Select Department')); ?></label>
                            <select name="department_id" onchange="loadlawyer()" class="department-id modal_select2">
                                <option value=""><?php echo e(__('Select Department')); ?></option>
                                <?php $__currentLoopData = $getDepartments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </select>
                        </div>
                        <div class="form-group d-none" id="modal-lawyer-box">
                            <label for=""><?php echo e(__('Select Lawyer')); ?></label>
                            <select name="" class="lawyer-id form-select" onchange="loadDate()">
                                <option value=""><?php echo e(__('Select Lawyer')); ?></option>
                            </select>
                        </div>
                        <div class="form-group d-none" id="modal-date-box">
                            <label for=""><?php echo e(__('Select Date')); ?></label>
                            <input type="text" name="date" class="form-control datepicker"
                                id="modal-datepicker-value">
                            <input type="hidden" name="lawyer_id" value="" id="modal_lawyer_id">
                        </div>
                        <div class="form-group d-none" id="modal-schedule-box">
                            <label for=""><?php echo e(__('Select Schedule')); ?></label>
                            <select name="schedule_id" class="form-select modal_select2"
                                id="available-modal-schedule">

                            </select>
                        </div>
                        <div id="modal-schedule-error" class="d-none"></div>
                        <div class="form-group">
                            <button type="button" class="btn btn-danger"
                                data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                            <input type="submit" value="<?php echo e(__('Submit')); ?>" class="btn btn-primary"
                                id="modal-sub" disabled>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
    <!-- // Modal -->
<?php /**PATH C:\xampp\htdocs\law\resources\views/layouts/client/header.blade.php ENDPATH**/ ?>