<?php if(subscriberContent()): ?>
    <!--Subscribe Start-->
    <div class="subscribe-area"
        style="background-image: url(<?php echo e(subscriberContent()?->image ? url(subscriberContent()?->image) : ''); ?>)">
        <div class="container">
            <div class="row ov_hd">
                <div class="col-md-11 col-lg-8 col-xl-7 m-auto wow fadeInDown">
                    <div class="main-headline white">
                        <h2 class="title"><?php echo e(ucwords(subscriberContent()?->title)); ?></h2>
                        <p><?php echo e(subscriberContent()?->description); ?></p>
                    </div>
                </div>
            </div>
            <div class="row ov_hd">
                <div class="col-md-12 wow fadeInUp" data-wow-delay="0.1s">
                    <div class="subscribe-form">
                        <form method="POST" action="<?php echo e(route('newsletter-request')); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="email" required name="email" placeholder="<?php echo e(__('Email')); ?>">
                            <button type="submit" class="btn-sub"><?php echo e(__('Subscribe')); ?></button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--Subscribe Start-->
<?php endif; ?>

<?php if(getPartners()->isNotEmpty()): ?>
    <!--Brand-Area Start-->
    <div class="brand-area bg-area">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="brand-carousel owl-carousel">
                        <?php $__currentLoopData = getPartners(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a aria-label="Partner" target="_blank" href="<?php echo e($item?->link ?? 'javascript:;'); ?>">
                                <div class="brand-item">
                                    <div class="brand-colume">
                                        <div class="brand-bg"></div>
                                        <img src="<?php echo e(url($item->image)); ?>" alt="Partner" loading="lazy">
                                    </div>
                                </div>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--Brand-Area End-->
<?php endif; ?>

<!--Footer Start-->
<div class="main-footer">
    <div class="top-footer">
        <div class="container">
            <div class="row">
                <div class="col-lg-4">
                    <div class="footer-address footer-address-first">
                        <ul>
                            <li>
                                <i class="far fa-envelope"></i>
                                <p class="title"><?php echo e(__('Email Address')); ?> </p>
                                <p><?php echo nl2br(e($contactInfo?->email)); ?></p>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="footer-address">
                        <ul>
                            <li>
                                <i class="fas fa-phone"></i>
                                <p class="title"><?php echo e(__('Phone')); ?></p>
                                <p><?php echo nl2br(e($contactInfo?->phone)); ?></p>

                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="footer-address">
                        <ul>
                            <li>
                                <i class="fas fa-map-marker-alt"></i>
                                <p class="title"><?php echo e(__('Address')); ?></p>
                                <p><?php echo nl2br(e($contactInfo?->address)); ?></p>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-area" style="background-image: url(<?php echo e(url('client/img/shape-2.webp')); ?>)">
        <div class="container">
            <div class="row justify-content-between">
                <div class="col-xxl-3 col-lg-3">
                    <div class="footer-item">
                        <p class="title"><?php echo e(__('About Us')); ?></p>
                        <div class="textwidget pe-0">
                            <p><?php echo e($contactInfo?->about); ?></p>
                            <a aria-label="<?php echo e(__('Details')); ?>" class="sm_fbtn"
                                href="<?php echo e(url('about-us')); ?>"><?php echo e(__('Details')); ?> →</a>
                            <ul class="icon">
                                <?php $__currentLoopData = getSocialLinks(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a target="_blank" aria-label="<?php echo e($social?->link); ?>" href="<?php echo e($social?->link); ?>"><i class="<?php echo e($social?->icon); ?>"></i></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-2 col-lg-2 col-md-6">
                    <div class="footer-item">
                        <p class="title"><?php echo e(__('Important Link')); ?></p>
                        <?php if($footerFirstMenu = footerFirstMenu()): ?>
                            <ul>
                                <?php $__currentLoopData = $footerFirstMenu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a <?php if($menu['open_new_tab']): ?> target="_blank" <?php endif; ?>
                                            href="<?php echo e($menu['link'] == '#' || empty($menu['link']) ? 'javascript:;' : url($menu['link'])); ?>"><?php echo e($menu['label']); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-xxl-2 col-lg-2 col-md-6">
                    <div class="footer-item">
                        <p class="title"><?php echo e(__('Account')); ?></p>
                        <?php if($footerSecondMenu = footerSecondMenu()): ?>
                            <ul>
                                <?php $__currentLoopData = $footerSecondMenu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a <?php if($menu['open_new_tab']): ?> target="_blank" <?php endif; ?>
                                            href="<?php echo e($menu['link'] == '#' || empty($menu['link']) ? 'javascript:;' : url($menu['link'])); ?>"><?php echo e($menu['label']); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-xxl-3 col-lg-4">
                    <div class="footer-item">
                        <p class="title"><?php echo e(__('Recent Post')); ?></p>
                        <?php $__currentLoopData = footerLatestNews(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="footer-recent-item">
                                <div class="footer-recent-photo">
                                    <a aria-label="<?php echo e($item?->title); ?>"
                                        href="<?php echo e(route('website.blog.details', $item?->slug)); ?>"><img
                                            src="<?php echo e(url($item?->thumbnail_image)); ?>" alt="<?php echo e($item?->title); ?>"
                                            loading="lazy"></a>
                                </div>
                                <div class="footer-recent-text">
                                    <a aria-label="<?php echo e($item?->title); ?>"
                                        href="<?php echo e(route('website.blog.details', $item?->slug)); ?>"><?php echo e($item?->title); ?></a>
                                    <div class="footer-post-date"><?php echo e(formattedDate($item?->created_at)); ?></div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                    <div class="d-flex gap-2 app-store-area">
                        <?php if($setting?->google_app_store_status): ?>
                            <a aria-label="Google play store" href="<?php echo e($setting?->google_app_store_link); ?>"><img
                                    src="<?php echo e(asset($setting?->google_app_store_img)); ?>"
                                    alt="google-play-store" loading="lazy"></a>
                        <?php endif; ?>
                        <?php if($setting?->apple_app_store_status): ?>
                            <a aria-label="Apple play store" href="<?php echo e($setting?->apple_app_store_link); ?>"><img
                                    src="<?php echo e(asset($setting?->apple_app_store_img)); ?>"
                                    alt="apple-play-store" loading="lazy"></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-copyrignt">
        <div class="container">
            <div class="copyright-text text-center">
                <p><?php echo e($contactInfo?->copyright); ?></p>
            </div>
        </div>
    </div>
</div>
<!--Footer End-->


<!--Scroll-Top-->
<div class="scroll-top">
    <i class="fas fa-angle-double-up"></i>
</div>
<!--Scroll-Top-->


<script>
    var isRtl = "<?php echo e(session()->get('text_direction') == 'rtl'); ?>"
    var rtlTrue = false;
    if (isRtl) {
        rtlTrue = true;
    }
</script>


<!--Js-->
<script src="<?php echo e(asset('global/js/jquery-3.7.1.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/js/bootstrap.bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset('client/js/jquery.nice-select.min.js')); ?>"></script>
<script src="<?php echo e(asset('client/js/popper.min.js')); ?>"></script>
<script src="<?php echo e(asset('client/js/jquery-ui.min.js')); ?>"></script>
<script src="<?php echo e(asset('client/js/jquery.magnific-popup.min.js')); ?>"></script>
<script src="<?php echo e(asset('client/js/jquery.collapse.js')); ?>"></script>
<script src="<?php echo e(asset('client/js/owl.carousel.min.js')); ?>"></script>
<script src="<?php echo e(asset('client/js/swiper-bundle.js')); ?>"></script>
<script src="<?php echo e(asset('client/js/jquery.filterizr.min.js')); ?>"></script>
<script src="<?php echo e(asset('client/js/select2.min.js')); ?>"></script>
<script src="<?php echo e(asset('client/js/wow.min.js')); ?>"></script>
<script src="<?php echo e(asset('client/js/slick.min.js')); ?>"></script>
<script src="<?php echo e(asset('client/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('client/js/viewportchecker.js')); ?>"></script>
<script src="<?php echo e(asset('client/js/bootstrap-datepicker.min.js')); ?>"></script>
<script src="<?php echo e(asset('client/js/jquery.waypoints.min.js')); ?>"></script>
<script src="<?php echo e(asset('client/js/jquery.counterup.min.js')); ?>"></script>
<script src="<?php echo e(asset('client/js/custom.js')); ?>?v=<?php echo e($setting?->version); ?>"></script>
<script src="<?php echo e(asset('global/toastr/toastr.min.js')); ?>"></script>
<script src="<?php echo e(asset('client/js/jquery-ui.js')); ?>"></script>
<script src="<?php echo e(asset('https://js.pusher.com/7.0/pusher.min.js')); ?>"></script>
<?php echo $__env->make('client.dynamic-js-variables', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="<?php echo e(asset('client/js/ajax-request.js')); ?>"></script>
<script>
    <?php if(Session::has('message')): ?>
        var type = "<?php echo e(Session::get('alert-type', 'info')); ?>"
        switch (type) {
            case 'info':
                toastr.info("<?php echo e(Session::get('message')); ?>");
                break;
            case 'success':
                toastr.success("<?php echo e(Session::get('message')); ?>");
                break;
            case 'warning':
                toastr.warning("<?php echo e(Session::get('message')); ?>");
                break;
            case 'error':
                toastr.error("<?php echo e(Session::get('message')); ?>");
                break;
        }
    <?php endif; ?>
</script>

<?php if($errors->any()): ?>
    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <script>
            toastr.error('<?php echo e($error); ?>');
        </script>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>

<!--Start of Tawk.to Script-->
<?php if($setting->tawk_status == 'active'): ?>
    <script type="text/javascript">
        "use strict";
        var Tawk_API = Tawk_API || {},
            Tawk_LoadStart = new Date();
        (function() {
            var s1 = document.createElement("script"),
                s0 = document.getElementsByTagName("script")[0];
            s1.async = true;
            s1.src = '<?php echo e($setting->tawk_chat_link); ?>';
            s1.charset = 'UTF-8';
            s1.setAttribute('crossorigin', '*');
            s0.parentNode.insertBefore(s1, s0);
        })();
    </script>
<?php endif; ?>
<!--End of Tawk.to Script-->


<?php if($setting->cookie_status == 'active'): ?>
    <script src="<?php echo e(asset('client/js/cookieconsent.min.js')); ?>"></script>

    <script>
        "use strict";
        window.addEventListener("load", function() {
            window.wpcc.init({
                "border": "<?php echo e($setting->border); ?>",
                "corners": "<?php echo e($setting->corners); ?>",
                "colors": {
                    "popup": {
                        "background": "<?php echo e($setting->background_color); ?>",
                        "text": "<?php echo e($setting->text_color); ?> !important",
                        "border": "<?php echo e($setting->border_color); ?>"
                    },
                    "button": {
                        "background": "<?php echo e($setting->btn_bg_color); ?>",
                        "text": "<?php echo e($setting->btn_text_color); ?>"
                    }
                },
                "content": {
                    "href": "<?php echo e(route('website.privacy-policy')); ?>",
                    "message": "<?php echo e($setting->message); ?>",
                    "link": "<?php echo e($setting->link_text); ?>",
                    "button": "<?php echo e($setting->btn_text); ?>"
                }
            })
        });
    </script>
<?php endif; ?>
<?php echo $__env->yieldPushContent('js'); ?>
<?php if(customCode()?->footer_javascript): ?>
    <script>
        "use strict";
        <?php echo customCode()->footer_javascript; ?>

    </script>
<?php endif; ?>

</body>

</html>
<?php /**PATH /home/sbrbot/law.sbrbot.trading/resources/views/layouts/client/footer.blade.php ENDPATH**/ ?>