    <li
        class="nav-item dropdown <?php echo e(isRoute(['admin.lawyer.*', 'admin.department.*', 'admin.department.gallery', 'admin.department.videos', 'admin.faq.by.department', 'admin.location.index', 'admin.leave.*'], 'active')); ?>">
        <a href="javascript:void()" class="nav-link has-dropdown"><i
                class="fas fa-gavel"></i><span><?php echo e(__('Lawyer')); ?></span></a>

        <ul class="dropdown-menu">
            <?php if(checkAdminHasPermission('department.view')): ?>
                <li
                    class="<?php echo e(isRoute(['admin.department.*', 'admin.department.gallery', 'admin.department.videos', 'admin.faq.by.department'], 'active')); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.department.index')); ?>">
                        <?php echo e(__('Department')); ?>

                    </a>
                </li>
            <?php endif; ?>
            <?php if(checkAdminHasPermission('location.view')): ?>
                <li class="<?php echo e(isRoute('admin.location.index', 'active')); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.location.index', ['code' => getSessionLanguage()])); ?>">
                        <?php echo e(__('Location')); ?>

                    </a>
                </li>
            <?php endif; ?>
            <?php if(checkAdminHasPermission('lawyer.view')): ?>
                <li class="<?php echo e(isRoute('admin.lawyer.*', 'active')); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.lawyer.index')); ?>">
                        <?php echo e(__('Lawyer')); ?>

                    </a>
                </li>
            <?php endif; ?>
            <?php if(checkAdminHasPermission('leave.management')): ?>
                <li class="<?php echo e(isRoute('admin.leave.*', 'active')); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.leave.index')); ?>">
                        <?php echo e(__('Leave')); ?>

                    </a>
                </li>
            <?php endif; ?>
        </ul>
    </li>
<?php /**PATH C:\xampp\htdocs\law\Modules/Lawyer\resources/views/sidebar.blade.php ENDPATH**/ ?>