<?php $__env->startSection('title'); ?>
    <title><?php echo e(seoSetting()->where('page_name', 'Lawyers')->first()?->seo_title ?? 'Lawyers | LawMent'); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
    <meta name="description"
        content="<?php echo e(seoSetting()->where('page_name', 'Lawyers')->first()?->seo_description ?? 'Lawyers | LawMent'); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('client-content'); ?>

    <!--Banner Start-->
    <div class="banner-area flex"
        style="background-image:url(<?php echo e($setting?->breadcrumb_image ? url($setting?->breadcrumb_image) : ''); ?>);">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="banner-text">
                        <h1><?php echo e(__('Lawyers ')); ?></h1>
                        <ul>
                            <li><a aria-label="<?php echo e(__('Home')); ?>" href="<?php echo e(url('/')); ?>"><?php echo e(__('Home')); ?></a></li>
                            <li><span><?php echo e(__('Lawyers ')); ?></span></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--Banner End-->


    <div class="lawyer-search">
        <div class="container">
            <div class="row">
                <div class="col-md-12">

                    <div class="s-container">
                        <form action="<?php echo e(route('website.search.lawyer')); ?>">

                            <div class="s-box">
                                <select name="location" class="form-control select2">
                                    <option value=""><?php echo e(__('Select Location')); ?></option>
                                    <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php echo e(@$location_id == $location?->id ? 'selected' : ''); ?>

                                            value="<?php echo e($location?->id); ?>"><?php echo e(ucwords($location?->name)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="s-box">
                                <select name="department" class="form-control select2">
                                    <option value=""><?php echo e(__('Select Department')); ?></option>
                                    <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php echo e(@$department_id == $department?->id ? 'selected' : ''); ?>

                                            value="<?php echo e($department?->id); ?>"><?php echo e(ucwords($department?->name)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="s-box">
                                <select name="lawyer" class="form-control select2">
                                    <option value=""><?php echo e(__('Select Lawyer')); ?></option>
                                    <?php $__currentLoopData = $lawyersForSearch; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lawyer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php echo e(@$lawyer_id == $lawyer->id ? 'selected' : ''); ?>

                                            value="<?php echo e($lawyer?->id); ?>">
                                            <?php echo e(ucwords($lawyer?->name)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="s-button">
                                <button type="submit"><?php echo e(__('Search')); ?></button>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>




    <!--Service Start-->
    <div class="team-page pb_70">
        <div class="container">
            <div class="row">

                <?php if($lawyers->count() != 0): ?>
                    <?php $__currentLoopData = $lawyers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lawyer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-3 col-md-4 col-sm-6 mt_30">
                            <div class="team-item">
                                <div class="team-photo">
                                    <img src="<?php echo e(url($lawyer?->image ? $lawyer?->image : $setting?->default_avatar)); ?>"
                                        alt="<?php echo e($lawyer?->name); ?>" loading="lazy">
                                </div>
                                <div class="team-text">
                                    <a aria-label="<?php echo e($lawyer?->name); ?>"
                                        href="<?php echo e(route('website.lawyer.details', $lawyer?->slug)); ?>"><?php echo e(ucfirst($lawyer?->name)); ?></a>
                                    <p><?php echo e(ucfirst($lawyer?->department?->name)); ?></p>
                                    <p><span><i class="fas fa-graduation-cap"></i> <?php echo e($lawyer?->designations); ?></span></p>
                                    <p><span><b><i class="fas fa-street-view"></i>
                                                <?php echo e(ucfirst($lawyer?->location?->name)); ?></b></span></p>
                                </div>
                                <div class="team-social">
                                    <ul>
                                        <?php $__currentLoopData = $lawyer?->socialMedia; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $socialMedia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><a target="_blank" aria-label="<?php echo e($socialMedia?->link); ?>"
                                                    href="<?php echo e($socialMedia?->link); ?>">
                                                    <i class="<?php echo e($socialMedia?->icon); ?>"></i>
                                                </a>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <h3 class="text-danger text-center mt-5"><?php echo e(__('Lawyer Not Found')); ?></h3>
                <?php endif; ?>


            </div>
            <?php if($lawyers->hasPages()): ?>
                <?php echo e($lawyers->links('client.paginator')); ?>

            <?php endif; ?>
        </div>
    </div>
    <!--Service End-->






<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.client.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\law\resources\views/client/lawyer/index.blade.php ENDPATH**/ ?>