<?php $__env->startSection('title'); ?>
    <title><?php echo e(seoSetting()->where('page_name', 'Department')->first()?->seo_title ?? 'Department | LawMent'); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
    <meta name="description"
        content="<?php echo e(seoSetting()->where('page_name', 'Department')->first()?->seo_description ?? 'Department | LawMent'); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('client-content'); ?>
    <!--Banner Start-->
    <div class="banner-area flex"
        style="background-image:url(<?php echo e($setting?->breadcrumb_image ? url($setting?->breadcrumb_image) : ''); ?>);">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="banner-text">
                        <h1><?php echo e(__('Departments')); ?></h1>
                        <ul>
                            <li><a aria-label="<?php echo e(__('Home')); ?>" href="<?php echo e(url('/')); ?>"><?php echo e(__('Home')); ?></a></li>
                            <li><span><?php echo e(__('Departments')); ?></span></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--Banner End-->

    <div class="case-study-home-page case-study-area pt_50">
        <div class="container">
            <div class="row">
                <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-4 col-md-6 mt_15">
                        <div class="case-item">
                            <div class="case-box">
                                <div class="case-image">
                                    <img src="<?php echo e($department?->thumbnail_image); ?>" alt="" loading="lazy">
                                    <div class="overlay"><a aria-label="<?php echo e($department?->name); ?>"
                                            href="<?php echo e(route('website.department.details', $department?->slug)); ?>"
                                            class="btn-case"><?php echo e(__('See Details')); ?></a>
                                    </div>
                                </div>
                                <div class="case-content">
                                    <h4 class="title"><a aria-label="<?php echo e($department?->name); ?>"
                                            href="<?php echo e(route('website.department.details', $department?->slug)); ?>"><?php echo e($department?->name); ?></a>
                                    </h4>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



            </div>
            <div class="mb-5">
                <?php if($departments->hasPages()): ?>
                    <?php echo e($departments->links('client.paginator')); ?>

                <?php endif; ?>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.client.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\law\resources\views/client/department/index.blade.php ENDPATH**/ ?>