<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Dashboard')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <?php if(checkAdminHasPermission('dashboard.view')): ?>
            
            <div class="row position-relative">
                <?php if(Route::is('admin.dashboard') && ($checkCredentials = checkCredentials())): ?>
                    <?php $__currentLoopData = $checkCredentials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $checkCredential): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($checkCredential->status): ?>
                            <div
                                class="alert alert-danger alert-has-icon alert-dismissible position-absolute w-100 missingCrentialsAlert">
                                <div class="alert-icon"><i class="far fa-lightbulb"></i></div>
                                <div class="alert-body">
                                    <div class="alert-title"><?php echo e($checkCredential->message); ?></div>
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>

                                    <?php echo e($checkCredential->description); ?> <b><a class="btn btn-sm btn-outline-warning"
                                            href="<?php echo e(!empty($checkCredential->route) ? route($checkCredential->route) : url($checkCredential->url)); ?>"><?php echo e(__('Update')); ?></a></b>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>    

            <?php if($setting->is_queable == 'active' && Cache::get('corn_working') !== 'working'): ?>
                <div class="alert alert-danger alert-has-icon alert-dismissible show fade">
                    <div class="alert-icon"><i class="fas fa-sync"></i></div>
                    <div class="alert-body">
                        <div class="alert-title"><a href="<?php echo e(route('admin.email-configuration')); ?>" target="_blank"
                                rel="noopener noreferrer"><?php echo e(__('Corn Job Is Not Running! Many features will be disabled and face errors')); ?></a>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>
        <section class="section">
            <?php if (isset($component)) { $__componentOriginaldbbc880c47f621cda59b70d6eb356b2f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaldbbc880c47f621cda59b70d6eb356b2f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.breadcrumb','data' => ['title' => ''.e(__('Dashboard')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => ''.e(__('Dashboard')).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaldbbc880c47f621cda59b70d6eb356b2f)): ?>
<?php $attributes = $__attributesOriginaldbbc880c47f621cda59b70d6eb356b2f; ?>
<?php unset($__attributesOriginaldbbc880c47f621cda59b70d6eb356b2f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldbbc880c47f621cda59b70d6eb356b2f)): ?>
<?php $component = $__componentOriginaldbbc880c47f621cda59b70d6eb356b2f; ?>
<?php unset($__componentOriginaldbbc880c47f621cda59b70d6eb356b2f); ?>
<?php endif; ?>
            <?php if(checkAdminHasPermission('dashboard.view')): ?>
                <div class="section-body">
                    <div class="row">
                        <!-- New Appointment -->
                        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                            <div class="card card-statistic-1">
                                <div class="card-icon bg-primary">
                                    <i class="fas fa-calendar"></i>
                                </div>
                                <div class="card-wrap">
                                    <div class="card-header">
                                        <h4><?php echo e(__('New Appointment')); ?></h4>
                                    </div>
                                    <div class="card-body">
                                        <?php echo e($new_appointment_qty ?? 0); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Pending Orders -->
                        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                            <div class="card card-statistic-1">
                                <div class="card-icon bg-warning">
                                    <i class="fas fa-shopping-bag"></i>
                                </div>
                                <div class="card-wrap">
                                    <div class="card-header">
                                        <h4><?php echo e(__('Pending Orders')); ?></h4>
                                    </div>
                                    <div class="card-body">
                                        <?php echo e($pending_orders_qty ?? 0); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Success Appointment -->
                        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                            <div class="card card-statistic-1">
                                <div class="card-icon bg-success">
                                    <i class="fas fa-calendar-check"></i>
                                </div>
                                <div class="card-wrap">
                                    <div class="card-header">
                                        <h4><?php echo e(__('Successful Appointment')); ?></h4>
                                    </div>
                                    <div class="card-body">
                                        <?php echo e($success_appointment_qty ?? 0); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Total Client -->
                        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                            <div class="card card-statistic-1">
                                <div class="card-icon bg-danger">
                                    <i class="fas fa-user"></i>
                                </div>
                                <div class="card-wrap">
                                    <div class="card-header">
                                        <h4><?php echo e(__('Total Client')); ?></h4>
                                    </div>
                                    <div class="card-body">
                                        <?php echo e($client_qty ?? 0); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Total Lawyer  -->
                        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                            <div class="card card-statistic-1">
                                <div class="card-icon bg-info">
                                    <i class="fas fa-gavel"></i>
                                </div>
                                <div class="card-wrap">
                                    <div class="card-header">
                                        <h4><?php echo e(__('Total Lawyer')); ?></h4>
                                    </div>
                                    <div class="card-body">
                                        <?php echo e($lawyer_qty ?? 0); ?>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Earnings Monthly -->
                        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                            <div class="card card-statistic-1">
                                <div class="card-icon bg-success">
                                    <i class="fas fa-dollar-sign"></i>
                                </div>
                                <div class="card-wrap">
                                    <div class="card-header">
                                        <h4><?php echo e(__('Earnings')); ?> (<?php echo e(__('Monthly')); ?>)</h4>
                                    </div>
                                    <div class="card-body">
                                        <?php echo e(currency($monthlyEarning)); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Earnings Total -->
                        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                            <div class="card card-statistic-1">
                                <div class="card-icon bg-success">
                                    <i class="fas fa-dollar-sign"></i>
                                </div>
                                <div class="card-wrap">
                                    <div class="card-header">
                                        <h4><?php echo e(__('Earnings')); ?> (<?php echo e(__('Total')); ?>)</h4>
                                    </div>
                                    <div class="card-body">
                                        <?php echo e(currency($totalEarning)); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Earnings Subscriber -->
                        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                            <div class="card card-statistic-1">
                                <div class="card-icon bg-dark">
                                    <i class="fas fa-bullhorn"></i>
                                </div>
                                <div class="card-wrap">
                                    <div class="card-header">
                                        <h4><?php echo e(__('Total Subscriber')); ?></h4>
                                    </div>
                                    <div class="card-body">
                                        <?php echo e($subscriber_qty ?? 0); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4><?php echo e(__('Pending Orders')); ?></h4>
                                </div>
                                <div class="p-0 card-body">
                                    <div class="table-responsive">
                                        <table class="table mb-0 table-striped">
                                            <thead>
                                                <tr>
                                                    <th><?php echo e(__('SN')); ?></th>
                                                    <th><?php echo e(__('Name')); ?></th>
                                                    <th><?php echo e(__('Email')); ?></th>
                                                    <th><?php echo e(__('Phone')); ?></th>
                                                    <th><?php echo e(__('Date')); ?></th>
                                                    <th><?php echo e(__('Payment')); ?></th>
                                                    <th><?php echo e(__('Action')); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__empty_1 = true; $__currentLoopData = $pending_orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $pending_order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <tr>
                                                        <td><?php echo e(++$index); ?></td>
                                                        <td><?php echo e($pending_order?->user?->name); ?></td>
                                                        <td><?php echo e($pending_order?->user?->email); ?></td>
                                                        <td><?php echo e($pending_order?->user?->details?->phone); ?></td>
                                                        <td><?php echo e(formattedDate($pending_order?->created_at)); ?></td>
                                                        </td>
                                                        <td>
                                                            <?php if($pending_order->payment_status == 0): ?>
                                                                <span
                                                                    class="badge bg-danger"><?php echo e(__('Pending')); ?></span>
                                                            <?php else: ?>
                                                                <span
                                                                    class="badge bg-success"><?php echo e(__('Success')); ?></span>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td>
                                                            <a href="<?php echo e(route('admin.order', $pending_order?->order_id)); ?>"
                                                                class="btn btn-success btn-sm"><i
                                                                    class="fas fa-eye"></i></a>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <?php if (isset($component)) { $__componentOriginal875c7a0bb47165de86ff51577f723b01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal875c7a0bb47165de86ff51577f723b01 = $attributes; } ?>
<?php $component = App\View\Components\EmptyTable::resolve(['name' => __(''),'route' => '','create' => 'no','message' => __('No data found!'),'colspan' => '7'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('empty-table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\EmptyTable::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $attributes = $__attributesOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__attributesOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $component = $__componentOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__componentOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4><?php echo e(__('Lawyer Payment In')); ?> <?php echo e(date('F, Y')); ?></h4>
                                </div>
                                <div class="p-0 card-body">
                                    <div class="table-responsive">
                                        <table class="table mb-0 table-striped">
                                            <thead>
                                                <tr>
                                                    <th><?php echo e(__('SN')); ?></th>
                                                    <th><?php echo e(__('Name')); ?></th>
                                                    <th><?php echo e(__('Email')); ?></th>
                                                    <th><?php echo e(__('Phone')); ?></th>
                                                    <th><?php echo e(__('Amount')); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__empty_1 = true; $__currentLoopData = $payment_histories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <tr>
                                                        <td><?php echo e(++$index); ?></td>
                                                        <td><?php echo e($payment?->lawyer?->name); ?></td>
                                                        <td><?php echo e($payment?->lawyer?->email); ?></td>
                                                        <td><?php echo e($payment?->lawyer?->phone); ?></td>
                                                        <td><?php echo e(currency($payment?->total_payment_fee)); ?></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <?php if (isset($component)) { $__componentOriginal875c7a0bb47165de86ff51577f723b01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal875c7a0bb47165de86ff51577f723b01 = $attributes; } ?>
<?php $component = App\View\Components\EmptyTable::resolve(['name' => __(''),'route' => '','create' => 'no','message' => __('No data found!'),'colspan' => '5'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('empty-table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\EmptyTable::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $attributes = $__attributesOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__attributesOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $component = $__componentOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__componentOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    <?php if(request()->get('par-page') !== 'all'): ?>
                                        <div class="float-right">
                                            <?php echo e($payment_histories->onEachSide(0)->links()); ?>

                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <!-- Area Chart -->
                        <div class="col">
                            <div class="mb-4 shadow card">
                                <!-- Card Header - Dropdown -->
                                <div class="flex-row py-3 card-header d-flex align-items-center justify-content-between">
                                    <h6 class="m-0 font-weight-bold text-primary"> <?php echo e(__('Earnings In')); ?>

                                        <?php echo e(request()->has('year') && request()->has('month') ? Carbon\Carbon::createFromFormat('Y-m', request('year') . '-' . request('month'))->format('F, Y') : date('F, Y')); ?>

                                    </h6>
                                    <div class="form-inline">
                                        <form method="get" onchange="$(this).trigger('submit');">
                                            <select name="year" id="year" class="form-control">
                                                <?php
                                                    $currentYear = Carbon\Carbon::now()->year;
                                                    $currentMonth = Carbon\Carbon::now()->month;
                                                    $selectYear = request('year') ?? $currentYear;
                                                    $selectMonth = request('month') ?? $currentMonth;
                                                ?>
                                                <?php for($i = $oldestYear; $i <= $latestYear; $i++): ?>
                                                    <option value="<?php echo e($i); ?>" <?php if($selectYear == $i): echo 'selected'; endif; ?>>
                                                        <?php echo e($i); ?></option>
                                                <?php endfor; ?>
                                            </select>
                                            <select name="month" id="month" class="form-control">
                                                <?php
                                                    for ($month = 1; $month <= 12; $month++) {
                                                        $monthNumber = str_pad($month, 2, '0', STR_PAD_LEFT);
                                                        $monthName = Carbon\Carbon::createFromFormat(
                                                            'm',
                                                            $month,
                                                        )->format('M');
                                                        echo '<option value="' .
                                                            $monthNumber .
                                                            '" ' .
                                                            ($selectMonth == $monthNumber ? 'selected' : '') .
                                                            '>' .
                                                            $monthName .
                                                            '</option>';
                                                    }
                                                ?>
                                            </select>
                                        </form>
                                    </div>
                                </div>
                                <!-- Card Body -->
                                <div class="card-body">
                                    <div class="chart-area">
                                        <canvas id="myAreaChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <?php if(checkAdminHasPermission('dashboard.view')): ?>
        <script src="<?php echo e(asset('backend/chart.js/chart.umd.min.js')); ?>"></script>
        <script>
            (function($) {
                "use strict";
                // Area Chart Example
                $(document).ready(function() {

                    var bData = <?php echo json_encode($monthly_data, 15, 512) ?>;
                    var jData = JSON.parse(bData);

                    var ctx = document.getElementById("myAreaChart");
                    var myLineChart = new Chart(ctx, {
                        type: 'line',
                        data: {
                            labels: ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13",
                                "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25",
                                "26", "27", "28", "29", "30", "31"
                            ],
                            datasets: [{
                                label: "<?php echo e(__('Earnings')); ?>",
                                lineTension: 0.3,
                                backgroundColor: "rgba(78, 115, 223, 0.05)",
                                borderColor: "rgba(78, 115, 223, 1)",
                                pointRadius: 3,
                                pointBackgroundColor: "rgba(78, 115, 223, 1)",
                                pointBorderColor: "rgba(78, 115, 223, 1)",
                                pointHoverRadius: 3,
                                pointHoverBackgroundColor: "rgba(78, 115, 223, 1)",
                                pointHoverBorderColor: "rgba(78, 115, 223, 1)",
                                pointHitRadius: 10,
                                pointBorderWidth: 2,
                                data: jData,
                            }],
                        },
                        options: {
                            maintainAspectRatio: false,
                            layout: {
                                padding: {
                                    left: 10,
                                    right: 25,
                                    top: 25,
                                    bottom: 0
                                }
                            },
                            scales: {
                                xAxes: [{
                                    time: {
                                        unit: 'date'
                                    },
                                    gridLines: {
                                        display: false,
                                        drawBorder: false
                                    },
                                    ticks: {
                                        maxTicksLimit: 7
                                    }
                                }],
                                yAxes: [{
                                    ticks: {
                                        maxTicksLimit: 5,
                                        padding: 10,
                                        // Include a dollar sign in the ticks
                                        callback: function(value, index, values) {
                                            return '<?php echo e(session()->get('currency_icon')); ?>' +
                                                number_format(value);
                                        }
                                    },
                                    gridLines: {
                                        color: "rgb(234, 236, 244)",
                                        zeroLineColor: "rgb(234, 236, 244)",
                                        drawBorder: false,
                                        borderDash: [2],
                                        zeroLineBorderDash: [2]
                                    }
                                }],
                            },
                            legend: {
                                display: false
                            },
                            tooltips: {
                                backgroundColor: "rgb(255,255,255)",
                                bodyFontColor: "#858796",
                                titleMarginBottom: 10,
                                titleFontColor: '#6e707e',
                                titleFontSize: 14,
                                borderColor: '#dddfeb',
                                borderWidth: 1,
                                xPadding: 15,
                                yPadding: 15,
                                displayColors: false,
                                intersect: false,
                                mode: 'index',
                                caretPadding: 10,
                                callbacks: {
                                    label: function(tooltipItem, chart) {
                                        var datasetLabel = chart.datasets[tooltipItem.datasetIndex]
                                            .label || '';
                                        return datasetLabel +
                                            ': <?php echo e(session()->get('currency_icon')); ?>' +
                                            number_format(tooltipItem.yLabel);
                                    }
                                }
                            }
                        }
                    });
                });
            })(jQuery);
        </script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\law\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>