<?php
    $header_admin = Auth::guard('admin')->user();
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <link rel="shortcut icon" href="" type="image/x-icon">
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">

    <?php echo $__env->yieldContent('title'); ?>
    <link rel="icon" href="<?php echo e(asset($setting->favicon)); ?>">
    <?php echo $__env->make('backend_layouts.partials.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('css'); ?>
</head>

<body>
    <div id="app">
        <div class="main-wrapper">
            <div class="navbar-bg"></div>
            <nav class="navbar navbar-expand-lg main-navbar px-3 py-2">
                <div class="form-inline">
                    <ul class="navbar-nav d-flex align-items-center">
                        <li><a href="#" data-toggle="sidebar" class="nav-link nav-link-lg"><i
                                    class="fas fa-bars"></i></a></li>

                        
                        <?php echo $__env->make('backend_layouts.partials.language_select', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        
                        <?php echo $__env->make('backend_layouts.partials.currency_select', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </ul>
                </div>
                <div class="me-auto search-box position-relative">
                    <?php if (isset($component)) { $__componentOriginal63bead4e908ebc125014a497e80acb69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal63bead4e908ebc125014a497e80acb69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.form-input','data' => ['id' => 'search_menu','placeholder' => __('Search option')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.form-input'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'search_menu','placeholder' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__('Search option'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal63bead4e908ebc125014a497e80acb69)): ?>
<?php $attributes = $__attributesOriginal63bead4e908ebc125014a497e80acb69; ?>
<?php unset($__attributesOriginal63bead4e908ebc125014a497e80acb69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal63bead4e908ebc125014a497e80acb69)): ?>
<?php $component = $__componentOriginal63bead4e908ebc125014a497e80acb69; ?>
<?php unset($__componentOriginal63bead4e908ebc125014a497e80acb69); ?>
<?php endif; ?>
                    <div id="admin_menu_list" class="position-absolute d-none rounded-2">
                        <?php $__currentLoopData = App\Enums\RouteList::getAll(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $route_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(checkAdminHasPermission($route_item?->permission) || empty($route_item?->permission)): ?>
                                <a <?php if(isset($route_item->tab)): ?>
                                        data-active-tab="<?php echo e($route_item->tab); ?>" class="border-bottom search-menu-item"
                                    <?php else: ?>
                                        class="border-bottom"
                                    <?php endif; ?>
                                    href="<?php echo e($route_item?->route); ?>"><?php echo e($route_item?->name); ?></a>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <a class="not-found-message d-none" href="javascript:;"><?php echo e(__('Not Found!')); ?></a>
                    </div>
                </div>
                <ul class="navbar-nav">
                    <li class="dropdown dropdown-list-toggle">
                        <a target="_blank" href="<?php echo e(route('home')); ?>" class="nav-link nav-link-lg p-0">
                            <i class="fas fa-home"></i> <span
                                class="d-md-none d-lg-inline-block"><?php echo e(__('Visit Website')); ?></span></i>
                        </a>
                    </li>

                    <li class="dropdown"><a href="javascript:;" data-bs-toggle="dropdown"
                            class="nav-link dropdown-toggle nav-link-lg nav-link-user">
                            <img alt="image"
                                src="<?php echo e(!empty($header_admin->image) ? asset($header_admin->image) : asset($setting->default_avatar)); ?>"
                                class="me-1 my-1 rounded-circle">

                            <div class="d-sm-none d-lg-inline-block"><?php echo e($header_admin->name); ?></div>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right">
                            <?php if(auth()->guard('admin')->user()->can('admin.profile.view')): ?>
                                <a href="<?php echo e(route('admin.edit-profile')); ?>"
                                    class="dropdown-item has-icon d-flex align-items-center <?php echo e(isRoute('admin.edit-profile', 'text-primary')); ?>">
                                    <i class="far fa-user"></i> <?php echo e(__('Profile')); ?>

                                </a>
                            <?php endif; ?>
                            <?php if(auth()->guard('admin')->user()->can('setting.view')): ?>
                                <a href="<?php echo e(route('admin.settings')); ?>"
                                    class="dropdown-item has-icon d-flex align-items-center <?php echo e(isRoute('admin.settings', 'text-primary')); ?>">
                                    <i class="fas fa-cog"></i> <?php echo e(__('Setting')); ?>

                                </a>
                            <?php endif; ?>
                            <a href="javascript:;" class="dropdown-item has-icon d-flex align-items-center"
                                onclick="event.preventDefault(); $('#admin-logout-form').trigger('submit');">
                                <i class="fas fa-sign-out-alt"></i> <?php echo e(__('Logout')); ?>

                            </a>
                        </div>
                    </li>

                </ul>
            </nav>

            <?php if(request()->routeIs(
                    'admin.general-setting',
                    'admin.crediential-setting',
                    'admin.email-configuration',
                    'admin.edit-email-template',
                    'admin.currency.*',
                    'admin.seo-setting',
                    'admin.custom-code',
                    'admin.cache-clear',
                    'admin.database-clear',
                    'admin.system-update.index',
                    'admin.addons.*',
                    'admin.admin.*',
                    'admin.languages.*',
                    'admin.basicpayment',
                    'admin.paymentgateway',
                    'admin.role.*')): ?>
                <?php echo $__env->make('admin.settings.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php else: ?>
                <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
            <?php echo $__env->yieldContent('admin-content'); ?>

            <footer class="main-footer">
                <div class="footer-right">
                    <span class="text-capitalize"><?php echo e(__('version')); ?>: <?php echo e($setting->version ?? ''); ?></span>
                </div>
            </footer>

        </div>
    </div>

    
    <form id="admin-logout-form" action="<?php echo e(route('admin.logout')); ?>" method="POST" class="d-none">
        <?php echo csrf_field(); ?>
    </form>
    
    <?php echo $__env->make('backend_layouts.partials.javascripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldPushContent('js'); ?>

</body>

</html>
<?php /**PATH C:\xampp\htdocs\law\resources\views/admin/master_layout.blade.php ENDPATH**/ ?>