<div class="main-sidebar">
    <aside id="sidebar-wrapper">
        <div class="sidebar-brand">
            <a href="<?php echo e(route('admin.dashboard')); ?>"><img class="w-75" src="<?php echo e(asset($setting->logo) ?? ''); ?>"
                    alt="<?php echo e($setting->app_name ?? ''); ?>"></a>
        </div>

        <div class="sidebar-brand sidebar-brand-sm">
            <a href="<?php echo e(route('admin.dashboard')); ?>"><img src="<?php echo e(asset($setting->favicon) ?? ''); ?>"
                    alt="<?php echo e($setting->app_name ?? ''); ?>"></a>
        </div>

        <ul class="sidebar-menu">
            <?php if(auth()->guard('admin')->user()->can('dashboard.view')): ?>
                <li class="<?php echo e(isRoute('admin.dashboard', 'active')); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>"><i class="fas fa-home"></i>
                        <span><?php echo e(__('Dashboard')); ?></span>
                    </a>
                </li>
            <?php endif; ?>

            <?php if(Module::isEnabled('Order') && checkAdminHasPermission('order.management')): ?>
                <?php echo $__env->make('order::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
            <?php if(checkAdminHasPermission('appointment.view') ||
                    checkAdminHasPermission('payment.view') ||
                    checkAdminHasPermission('schedule.view') ||
                    checkAdminHasPermission('day.view')): ?>
                <?php if(Module::isEnabled('Appointment')): ?>
                    <?php echo $__env->make('appointment::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
            <?php endif; ?>

            <?php if(Module::isEnabled('Customer') && checkAdminHasPermission('client.view')): ?>
                <?php echo $__env->make('customer::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>

            <?php if(checkAdminHasPermission('lawyer.view') || checkAdminHasPermission('leave.management') ||
                    checkAdminHasPermission('department.view') ||
                    checkAdminHasPermission('location.view') ||
                    checkAdminHasPermission('service.view') ||
                    checkAdminHasPermission('blog.category.view') ||
                    checkAdminHasPermission('blog.view') || checkAdminHasPermission('blog.comment.view')): ?>
                <li class="menu-header"><?php echo e(__('Manage Contents')); ?></li>

                <?php if(Module::isEnabled('Lawyer') && (checkAdminHasPermission('lawyer.view') || checkAdminHasPermission('leave.management') || checkAdminHasPermission('location.view') || checkAdminHasPermission('department.view'))): ?>
                    <?php echo $__env->make('lawyer::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if(Module::isEnabled('Service') && checkAdminHasPermission('service.view')): ?>
                    <?php echo $__env->make('service::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if(Module::isEnabled('Blog') && (checkAdminHasPermission('blog.category.view') || checkAdminHasPermission('blog.view') || checkAdminHasPermission('blog.comment.view'))): ?>
                    <?php echo $__env->make('blog::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

            <?php endif; ?>

            <?php if(checkAdminHasPermission('menu.view') ||
                    checkAdminHasPermission('slider.view') ||
                    checkAdminHasPermission('feature.view') ||
                    checkAdminHasPermission('work.section.view') ||
                    checkAdminHasPermission('counter.view') ||
                    checkAdminHasPermission('partner.view') ||
                    checkAdminHasPermission('page.aboutus.view') ||
                    checkAdminHasPermission('page.faq.view') ||
                    checkAdminHasPermission('faq.view') ||
                    checkAdminHasPermission('social.link.management') || checkAdminHasPermission('faq.category.view') ||
                    checkAdminHasPermission('page.view') ||
                    checkAdminHasPermission('section.view')): ?>

                <li class="menu-header"><?php echo e(__('Manage Website')); ?></li>

                <?php if(Module::isEnabled('CustomMenu') && checkAdminHasPermission('menu.view')): ?>
                    <?php echo $__env->make('custommenu::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if(Module::isEnabled('HomeSection') &&
                        (checkAdminHasPermission('slider.view') ||
                            checkAdminHasPermission('feature.view') ||
                            checkAdminHasPermission('work.section.view') ||
                            checkAdminHasPermission('counter.view') ||
                            checkAdminHasPermission('partner.view') ||
                            checkAdminHasPermission('section.view'))): ?>
                    <?php echo $__env->make('homesection::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if(checkAdminHasPermission('page.aboutus.view') || checkAdminHasPermission('page.faq.view') || checkAdminHasPermission('page.view')): ?>
                    <li
                        class="nav-item dropdown <?php echo e(isRoute(['admin.pages.about-us.index', 'admin.pages.contact-page.index', 'admin.pages.faq-page.index', 'admin.custom-pages.*', 'admin.pages.utility-page.index', 'admin.social.media.*','admin.pages.faq.index'], 'active')); ?>">
                        <a href="javascript:;" class="nav-link has-dropdown">
                            <i class="fas fa-th"></i><span><?php echo e(__('Pages')); ?></span>
                        </a>
                        <ul class="dropdown-menu">
                            <?php if(checkAdminHasPermission('page.aboutus.view')): ?>
                                <li class="<?php echo e(isRoute('admin.pages.about-us.index', 'active')); ?>">
                                    <a class="nav-link"
                                        href="<?php echo e(route('admin.pages.about-us.index', ['code' => getSessionLanguage()])); ?>">
                                        <?php echo e(__('About Us')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(checkAdminHasPermission('page.faq.view')): ?>
                                <li class="<?php echo e(isRoute('admin.pages.faq.index', 'active')); ?>">
                                    <a class="nav-link"
                                        href="<?php echo e(route('admin.pages.faq.index')); ?>">
                                        <?php echo e(__('FAQ Page')); ?>

                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(Module::isEnabled('PageBuilder') && checkAdminHasPermission('page.view')): ?>
                                <?php echo $__env->make('pagebuilder::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

                <?php if(Module::isEnabled('Faq') && checkAdminHasPermission('faq.category.view')): ?>
                    <?php echo $__env->make('faq::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if(Module::isEnabled('SocialLink') && checkAdminHasPermission('social.link.management')): ?>
                    <?php echo $__env->make('sociallink::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

            <?php endif; ?>
            <?php if(checkAdminHasPermission('setting.view') ||
                    checkAdminHasPermission('basic.payment.view') ||
                    checkAdminHasPermission('currency.view') ||
                    checkAdminHasPermission('language.view') ||
                    checkAdminHasPermission('role.view') || 
                    checkAdminHasPermission('addon.view') ||
                    checkAdminHasPermission('admin.view')): ?>

                <li class="menu-header"><?php echo e(__('Others')); ?></li>

                <?php if(Module::isEnabled('GlobalSetting')): ?>
                    <li class="<?php echo e(isRoute('admin.settings', 'active')); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.settings')); ?>"><i class="fas fa-cog"></i>
                            <span><?php echo e(__('Settings')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
            <?php endif; ?>

            <?php if(Module::isEnabled('App') && checkAdminHasPermission('app.management')): ?>
                <?php echo $__env->make('app::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>

            <?php if(Module::isEnabled('PaymentWithdraw') && checkAdminHasPermission('withdraw.management')): ?>
                <?php echo $__env->make('paymentwithdraw::admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>

            <?php if(Module::isEnabled('NewsLetter') && (checkAdminHasPermission('newsletter.view') || checkAdminHasPermission('newsletter.mail') || checkAdminHasPermission('newsletter.content.view'))): ?>
                <?php echo $__env->make('newsletter::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>

            <?php if(Module::isEnabled('Testimonial') && checkAdminHasPermission('testimonial.view')): ?>
                <?php echo $__env->make('testimonial::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>

            <?php if(Module::isEnabled('ContactMessage') && (checkAdminHasPermission('contact.message.view') || checkAdminHasPermission('contact.info.view'))): ?>
                <?php echo $__env->make('contactmessage::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
            <li class="nav-item dropdown <?php echo e(isRoute('admin.addon.*') ? 'active' : ''); ?>" id="addon_sidemenu">
                <a class="nav-link has-dropdown" data-toggle="dropdown" href="#"><i class="fas fa-gem"></i>
                    <span><?php echo e(__('Manage Addons')); ?> </span>
                </a>
                <ul class="dropdown-menu addon_menu">
                    <?php if ($__env->exists('admin.addons')) echo $__env->make('admin.addons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </ul>
            </li>
        </ul>
        <div class="py-3 text-center">
            <div class="btn-sm-group-vertical version_button" role="group" aria-label="Responsive button group">
                <button class="btn btn-primary logout_btn mt-2 text-capitalize" disabled><?php echo e(__('version')); ?>

                    <?php echo e($setting->version ?? '1.0.0'); ?></button>
                <button class="btn btn-danger mt-2"
                    onclick="event.preventDefault(); $('#admin-logout-form').trigger('submit');"><i
                        class="fas fa-sign-out-alt"></i></button>
            </div>
        </div>
    </aside>
</div>
<?php /**PATH C:\xampp\htdocs\law\resources\views/admin/sidebar.blade.php ENDPATH**/ ?>