<?php $__env->startSection('title'); ?>
    <title><?php echo e(seoSetting()->where('page_name', 'Home')->first()->seo_title ?? 'LawMent'); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta'); ?>
    <meta name="description" content="<?php echo e(seoSetting()->where('page_name', 'Home')->first()->seo_description ?? 'LawMent'); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('client-content'); ?>

    <!--Slider Start-->
    <div class="slider" id="main-slider">
        <div class="doc-search-item">
            <div class="d-flex align-items-center h_100_p">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-xl-10 col-xxl-9">
                            <div class="v-mid-content">
                                <div class="heading">
                                    <h2><?php echo e(__('Search The Best lawyers')); ?></h2>
                                    <p><?php echo e(__('Find out department and location based lawyers near your area')); ?></p>
                                </div>
                                <div class="doc-search-section">
                                    <form action="<?php echo e(route('website.search.lawyer')); ?>">
                                        <div class="box">
                                            <select name="location" class="form-control select2">
                                                <option value=""><?php echo e(__('Select Location')); ?></option>
                                                <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php echo e(@$location_id == $location?->id ? 'selected' : ''); ?>

                                                        value="<?php echo e($location?->id); ?>"><?php echo e(ucwords($location?->name)); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="box">
                                            <select name="department" class="form-control select2">
                                                <option value="">
                                                    <?php echo e(__('Select Department')); ?></option>
                                                <?php $__currentLoopData = $departmentsForSearch; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php echo e(@$department_id == $department?->id ? 'selected' : ''); ?>

                                                        value="<?php echo e($department?->id); ?>"><?php echo e(ucwords($department?->name)); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="box">
                                            <select name="lawyer" class="form-control select2">
                                                <option value="">
                                                    <?php echo e(__('Select Lawyer')); ?></option>
                                                <?php $__currentLoopData = $lawyersForSearch; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lawyer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php echo e(@$lawyer_id == $lawyer?->id ? 'selected' : ''); ?>

                                                        value="<?php echo e($lawyer?->id); ?>">
                                                        <?php echo e(ucwords($lawyer?->name)); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="doc-search-button">
                                            <button type="submit" class="btn btn-danger"><?php echo e(__('Search')); ?></button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="banner_slider_area">
            <div class="banner_slider_overlay">
                <div class="row banner_slider">
                    <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-12">
                            <div class="banner_slider_item">
                                <img src="<?php echo e(url($item->image)); ?>" alt="<?php echo e($item->title); ?>" class="img-fluid w-100">
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

    </div>
    <!--Slider End-->


    <!--Why Us Start-->
    <?php if(1 == $home_sections?->feature_status): ?>
        <section class="why-us-area pt_30">
            <div class="container">
                <div class="row">
                    <?php $__currentLoopData = $features->take($home_sections?->feature_how_many); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-4 choose-col">
                            <div class="choose-item flex" style="background-image: url(<?php echo e(url($feature->image)); ?>)">
                                <div class="choose-icon">
                                    <i class="<?php echo e($feature->icon); ?>"></i>
                                </div>
                                <div class="choose-text">
                                    <h2 class="title"><?php echo e($feature->title); ?></h2>
                                    <p>
                                        <?php echo e($feature->description); ?>

                                    </p>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
        </section>
        <!--why Us End-->
    <?php endif; ?>


    <?php if(1 == $home_sections?->work_status): ?>
        <!--Feature Start-->
        <section class="about-area">
            <div class="container">
                <div class="row ov_hd">
                    <div class="col-md-11 col-lg-8 col-xl-7 m-auto wow fadeInDown">
                        <div class="main-headline">
                            <h2 class="title"><span><?php echo e(ucfirst($home_sections?->work_first_heading)); ?></span>
                                <?php echo e(ucfirst($home_sections?->work_second_heading)); ?></h2>
                            <p><?php echo e($home_sections?->work_description); ?></p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container">
                <div class="row ov_hd">
                    <div class="col-lg-6 wow fadeInLeft" data-wow-delay="0.2s">
                        <div class="about-skey mt_65">
                            <div class="about-img">
                                <img src="<?php echo e($work?->image ? url($work?->image) : ''); ?>"
                                    alt="<?php echo e($home_sections?->work_first_heading . ' ' . $home_sections?->work_second_heading); ?>"
                                    loading="lazy">
                                <div class="video-section video-section-home">
                                    <a aria-label="<?php echo e($home_sections?->work_first_heading . ' ' . $home_sections?->work_second_heading); ?>"
                                        class="video-button mgVideo" href="<?php echo e($work?->video); ?>"><span></span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 wow fadeInRight" data-wow-delay="0.2s">
                        <div class="feature-section-text mt_50">
                            <h2><?php echo e($work?->title); ?></h2>
                            <div class="feature-accordion" id="accordion">
                                <?php $__currentLoopData = $workFaqs?->take($home_sections?->work_how_many); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faqIndex => $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="faq-item card">
                                        <div class="faq-header" id="heading1-<?php echo e($faq->id); ?>">
                                            <button class="faq-button <?php echo e($faqIndex != 0 ? 'collapsed' : ''); ?>"
                                                data-bs-toggle="collapse" data-bs-target="#collapse1-<?php echo e($faq->id); ?>"
                                                aria-expanded="true"
                                                aria-controls="collapse1-<?php echo e($faq->id); ?>"><?php echo e($faq->question); ?></button>
                                        </div>

                                        <div id="collapse1-<?php echo e($faq->id); ?>"
                                            class="collapse <?php echo e($faqIndex == 0 ? 'show' : ''); ?>"
                                            aria-labelledby="heading1-<?php echo e($faq->id); ?>" data-bs-parent="#accordion">
                                            <div class="faq-body">
                                                <?php echo $faq->answer; ?>

                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--Feature End-->
    <?php endif; ?>


    <?php if(1 == $home_sections?->service_status): ?>
        <!--Service Start-->
        <section class="service-area bg-area">
            <div class="container">
                <div class="row">
                    <div class="col-md-11 col-lg-8 col-xl-7 m-auto wow fadeInDown">
                        <div class="main-headline">
                            <h2 class="title"><span><?php echo e(ucfirst($home_sections?->service_first_heading)); ?></span>
                                <?php echo e(ucfirst($home_sections?->service_second_heading)); ?></h2>
                            <p><?php echo e($home_sections?->service_description); ?></p>
                        </div>
                    </div>
                </div>
                <div class="row service-row">
                    <div class="col-md-12">
                        <div class="service-coloum-area">
                            <?php $__currentLoopData = $services?->take($home_sections?->service_how_many); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="service-coloum">
                                    <div class="service-item">
                                        <i class="<?php echo e($service?->icon); ?>"></i>
                                        <a aria-label="<?php echo e($service?->title); ?>"
                                            href="<?php echo e(route('website.service.details', $service?->slug)); ?>">
                                            <h3 class="title"><?php echo e($service?->title); ?></h3>
                                        </a>
                                        <p><?php echo e($service?->sort_description); ?></p>
                                        <a aria-label="<?php echo e(__('Service Details')); ?>"
                                            href="<?php echo e(route('website.service.details', $service?->slug)); ?>"><?php echo e(__('Service Details')); ?>

                                            →</a>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="home-button ser-btn">
                            <a aria-label="<?php echo e(__('All Service')); ?>"
                                href="<?php echo e(url('service')); ?>"><?php echo e(__('All Service')); ?></a>
                        </div>
                    </div>
                </div>
                <!--Counter Start-->
                <div class="counter-row row"
                    style="background-image: url(<?php echo e(asset('uploads/website-images/overview-banner.webp')); ?>)">
                    <?php $__currentLoopData = $overviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $overview): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-3 col-6 mt_30 wow fadeInDown" data-wow-delay="0.2s">
                            <div class="counter-item">
                                <div class="counter-icon">
                                    <i class="<?php echo e($overview?->icon); ?>"></i>
                                </div>
                                <span class="counter counter_up"><?php echo e($overview?->qty); ?></span>
                                <p class="title"><?php echo e($overview?->title); ?></p>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <!--Counter End-->
            </div>
        </section>
        <!--Service End-->
    <?php endif; ?>


    <?php if(1 == $home_sections?->department_status): ?>
        <!--Department Start-->
        <section class="case-study-home-page case-study-area pb_40">
            <div class="container">
                <div class="row mb_25 mt_50">
                    <div class="col-md-11 col-lg-8 col-xl-7 m-auto wow fadeInDown" data-wow-delay="0.1s">
                        <div class="main-headline">
                            <h2 class="title"><span><?php echo e(ucfirst($home_sections?->department_first_heading)); ?></span>
                                <?php echo e(ucfirst($home_sections?->department_second_heading)); ?></h2>
                            <p><?php echo e($home_sections?->department_description); ?></p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <?php $__currentLoopData = $departments->take($home_sections?->department_how_many); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-4 col-md-6 mt_15">
                            <div class="case-item">
                                <div class="case-box">
                                    <div class="case-image">
                                        <img src="<?php echo e(url($department?->thumbnail_image)); ?>"
                                            alt="<?php echo e($department?->name); ?>" loading="lazy">
                                        <div class="overlay"><a aria-label="<?php echo e(__('See Details')); ?>"
                                                href="<?php echo e(route('website.department.details', $department?->slug)); ?>"
                                                class="btn-case"><?php echo e(__('See Details')); ?></a>
                                        </div>
                                    </div>
                                    <div class="case-content">
                                        <h3 class="title"><a aria-label="<?php echo e($department?->name); ?>"
                                                href="<?php echo e(route('website.department.details', $department?->slug)); ?>"><?php echo e($department?->name); ?></a>
                                        </h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="row mb_60">
                    <div class="col-md-12">
                        <div class="home-button">
                            <a aria-label="<?php echo e(__('All Department')); ?>"
                                href="<?php echo e(url('department')); ?>"><?php echo e(__('All Department')); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>


    <?php if(1 == $home_sections?->client_status): ?>
        <!--Testimonial Start-->
        <section class="testimonial-area <?php echo e($home_sections?->department_status == 0 ? 'mt_200' : ''); ?>">
            <div class="container">
                <div class="row">
                    <div class="col-md-11 col-lg-8 col-xl-7 m-auto wow fadeInDown">
                        <div class="main-headline">
                            <h2 class="title"><span><?php echo e(ucfirst($home_sections?->client_first_heading)); ?></span>
                                <?php echo e(ucfirst($home_sections?->client_second_heading)); ?></h2>
                            <p><?php echo e($home_sections?->client_description); ?></p>
                        </div>
                    </div>
                </div>

                <div class="row testimonial_slider mt_30">
                    <?php $__currentLoopData = $testimonials->take($home_sections?->client_how_many); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-12">
                            <div class="testimonial-texarea">
                                <div class="testimonial-item wow fadeIn" data-wow-delay="0.2s">
                                    <p class="wow fadeInDown" data-wow-delay="0.2s">
                                        <?php echo e($client?->comment); ?>

                                    </p>
                                    <div class="testi-info wow fadeInUp d-flex align-items-center home-testi-info"
                                        data-wow-delay="0.2s">
                                        <img src="<?php echo e(!empty($client?->image) ? url($client?->image) : ''); ?>"
                                            alt="<?php echo e($client?->name); ?>" loading="lazy">
                                        <div>
                                            <h3 class="title"><?php echo e($client?->name); ?></h3>
                                            <span><?php echo e($client?->designation); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

            </div>
        </section>
        <!--Testimonial End-->
    <?php endif; ?>


    <?php if(1 == $home_sections?->lawyer_status): ?>
        <!--Lawyer Area Start-->
        <section class="team-area team_slider_area">
            <div class="container">
                <div class="row mb_30">
                    <div class="col-md-11 col-lg-8 col-xl-7 m-auto wow fadeInDown">
                        <div class="main-headline">
                            <h2 class="title"><span><?php echo e(ucfirst($home_sections?->lawyer_first_heading)); ?></span>
                                <?php echo e(ucfirst($home_sections?->lawyer_second_heading)); ?></h2>
                            <p><?php echo e($home_sections?->lawyer_description); ?></p>
                        </div>
                    </div>
                </div>

                <div class="row lawyer_slider">
                    <?php $__currentLoopData = $lawyers->take($home_sections?->lawyer_how_many); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lawyer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-4">
                            <div class="team-item">
                                <div class="team-photo">
                                    <img src="<?php echo e(url($lawyer?->image)); ?>" alt="<?php echo e($lawyer?->name); ?>" loading="lazy">
                                </div>
                                <div class="team-text">
                                    <a
                                        href="<?php echo e(route('website.lawyer.details', $lawyer?->slug)); ?>"><?php echo e($lawyer?->name); ?></a>
                                    <p><?php echo e($lawyer?->department->name); ?></p>
                                    <p><span><i class="fas fa-graduation-cap"></i> <?php echo e($lawyer?->designations); ?></span>
                                    </p>
                                    <p><span><b><i class="fas fa-street-view"></i>
                                                <?php echo e(ucfirst($lawyer?->location?->name)); ?></b></span></p>
                                </div>
                                <div class="team-social">
                                    <ul>
                                        <?php $__currentLoopData = $lawyer?->socialMedia; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $socialMedia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><a target="_blank" aria-label="<?php echo e($socialMedia?->link); ?>"
                                                    href="<?php echo e($socialMedia?->link); ?>"><i class="<?php echo e($socialMedia?->icon); ?>"></i></a>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

            </div>
        </section>
        <!--Lawyer Area End-->
    <?php endif; ?>


    <?php if(1 == $home_sections?->blog_status): ?>
        <!--Blog-Area Start-->
        <section class="blog-area bg_ecf1f8">
            <div class="container">
                <div class="row">
                    <div class="col-md-11 col-lg-8 col-xl-7 m-auto wow fadeInDown">
                        <div class="main-headline">
                            <h2 class="title"><span><?php echo e(ucfirst($home_sections?->blog_first_heading)); ?></span>
                                <?php echo e(ucfirst($home_sections?->blog_second_heading)); ?></h2>
                            <p><?php echo e($home_sections?->blog_description); ?></p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <?php if($feature_blog): ?>
                        <div class="col-md-6">
                            <div class="blog-item first-blog">
                                <a aria-label="<?php echo e($feature_blog?->title); ?>"
                                    href="<?php echo e(route('website.blog.details', $feature_blog?->slug)); ?>"
                                    class="image-effect">
                                    <div class="blog-image">
                                        <img src="<?php echo e(url($feature_blog?->image)); ?>" alt="<?php echo e($feature_blog?->title); ?>"
                                            loading="lazy">
                                    </div>
                                </a>
                                <div class="blog-text">
                                    <div class="blog-author">
                                        <span><i class="fas fa-user"></i>
                                            <?php echo e($feature_blog?->admin?->name ?? __('Admin')); ?></span>
                                        <span><i class="far fa-calendar-alt"></i>
                                            <?php echo e(formattedDate($feature_blog?->created_at)); ?></span>
                                    </div>
                                    <h3 class="title"><a aria-label="<?php echo e($feature_blog?->title); ?>"
                                            href="<?php echo e(route('website.blog.details', $feature_blog?->slug)); ?>"><?php echo e($feature_blog?->title); ?></a>
                                    </h3>
                                    <p>
                                        <?php echo e($feature_blog?->sort_description); ?>

                                    </p>
                                    <a class="sm_btn" aria-label="<?php echo e(__('Details')); ?>"
                                        href="<?php echo e(route('website.blog.details', $feature_blog?->slug)); ?>"><?php echo e(__('Details')); ?>

                                        →</a>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="col-md-6 home_blog_slider">
                        <div class="blog-carousel owl-carousel">
                            <?php $i=0; ?>
                            <?php $__currentLoopData = $blogs?->take($home_sections?->blog_how_many); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $i++; ?>
                                <?php if($i == 1): ?>
                                    <?php continue; ?>
                                <?php endif; ?>
                                <div class="blog-item effect-item">
                                    <a aria-label="<?php echo e($blog?->title); ?>"
                                        href="<?php echo e(route('website.blog.details', $blog?->slug)); ?>" class="image-effect">
                                        <div class="blog-image">
                                            <img src="<?php echo e($blog?->thumbnail_image); ?>" alt="<?php echo e($blog?->title); ?>"
                                                loading="lazy">
                                        </div>
                                    </a>
                                    <div class="blog-text">
                                        <div class="blog-author">
                                            <span><i class="fas fa-user"></i>
                                                <?php echo e($blog?->admin?->name ?? __('Admin')); ?></span>
                                            <span><i class="far fa-calendar-alt"></i>
                                                <?php echo e(formattedDate($blog?->created_at)); ?></span>
                                        </div>
                                        <h3 class="title"><a aria-label="<?php echo e($blog?->title); ?>"
                                                href="<?php echo e(route('website.blog.details', $blog?->slug)); ?>"><?php echo e(Str::limit($blog?->title,30,'...')); ?></a>
                                        </h3>
                                        <p>
                                            <?php echo e($blog?->sort_description); ?>

                                        </p>
                                        <a class="sm_btn" aria-label="<?php echo e(__('Details')); ?>"
                                            href="<?php echo e(route('website.blog.details', $blog?->slug)); ?>"><?php echo e(__('Details')); ?>

                                            →</a>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--Blog-Area End-->
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.client.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\law\resources\views/client/index.blade.php ENDPATH**/ ?>